<?php class Deliveryboy_model extends CI_Model
{
    /******************** Data-Base Functions ****************************/
    function __construct()
    {
        parent::__construct();
        
       
       $this->load->database('grocery_database');    
    }

    public function update_data($table, $field, $id, $data)
    {
        $this->db->where($field, $id);
        return $this->db->update($table, $data);
    }
    public function select_column_where($columns, $table_name, $condition)
    {
        return $this->db
            ->select($columns)
            ->where($condition)
            ->get($table_name)
            ->result_array();
    }
    
    function set_f_token_app($user_login_id, $token)
    {
        $this->db->where('deli_user_id', $user_login_id);
        $this->db->update('grocery_deliveryboy', ['f_token_web' =>$token]);
        
    }
    

      public function Update($table, $f, $w = 0)
    {
        if ($w != 0) {
            $this->db->where($w);
        }
        $query = $this->db->update($table, $f);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }
     public function get_sellerdata($seller_id)
    {
        $this->db->select('*');
        $this->db->from('grocery_seller');
        $this->db->where('grocery_seller.seller_id', $seller_id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function get_deliveryboy_name($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_deliveryboy');
        $this->db->where('grocery_deliveryboy.deli_user_id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_sellerid($id)
    {
        $this->db->select('sellar_id');
        $this->db->from('grocery_product');
        $this->db->where('grocery_product.id', $id);
        $query = $this->db->get();
        return $query->row();
    }

    public function get_deliveryallorder($pincode, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,grocery_categories.cat_name,grocery_users.name,
        product_trasfer_delivery.status as deliverystatus,product_trasfer_delivery.rejected_date as rejected_date,product_trasfer_delivery.rejected_reason as rejected_reason');
        $this->db->from('payment_details');
         $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_deliveryallorder_payid($payid, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,grocery_categories.cat_name,grocery_users.name,
        product_trasfer_delivery.status as deliverystatus,product_trasfer_delivery.rejected_date as rejected_date,product_trasfer_delivery.rejected_reason as rejected_reason,payment_details.phone as phone');
        $this->db->from('payment_details');
         $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->where('payment_details.id', $payid);
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_deliverypendorder($pincode, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,
        grocery_categories.cat_name,product_trasfer_delivery.status as deliverystatus,        
        grocery_seller.phone as sellerphone,grocery_seller.PinCode as sellerPinCode,
        grocery_seller.locality as sellerlocality,grocery_seller.landmark as sellerlandmark,
        grocery_seller.store_name as sellerstore_name,
        grocery_seller.seller_name as seller_name,
        grocery_seller.city as sellercity,grocery_seller.state as sellerstate,
        grocery_seller.district as sellerdistrict,        
        grocery_users.name, customer_address.phone as cus_phone');
        $this->db->from('payment_details');
        $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');               
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id');
        $this->db->join('grocery_seller', 'grocery_seller.seller_id=product_trasfer_delivery.seller_id'); 
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->where('payment_details.order_status', 'S');
        $this->db->where('product_trasfer_delivery.status', '0');
        $this->db->or_where('product_trasfer_delivery.status', '1');
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    } 
    public function get_deliverypendorder_payid($payid, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,
        grocery_categories.cat_name,product_trasfer_delivery.status as deliverystatus,        
        grocery_seller.phone as sellerphone,grocery_seller.PinCode as sellerPinCode,
        grocery_seller.locality as sellerlocality,grocery_seller.landmark as sellerlandmark,
        grocery_seller.store_name as sellerstore_name,
        grocery_seller.seller_name as seller_name,
        grocery_seller.city as sellercity,grocery_seller.state as sellerstate,
        grocery_seller.district as sellerdistrict,        
        grocery_users.name, customer_address.phone as cus_phone');
        $this->db->from('payment_details');
        $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');               
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id');
        $this->db->join('grocery_seller', 'grocery_seller.seller_id=product_trasfer_delivery.seller_id'); 
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
         $this->db->where('payment_details.id', $payid);
        $this->db->where('payment_details.order_status', 'S');
        $this->db->where('product_trasfer_delivery.status', '0');
        $this->db->or_where('product_trasfer_delivery.status', '1');
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_deliveryboycancelorder($pincode, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,grocery_users.name,grocery_categories.cat_name,product_trasfer_delivery.status as deliverystatus');
        $this->db->from('payment_details');
         $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->where('payment_details.order_status', 'DC');
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_deliveryboycancelorder_payid($payid, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,grocery_users.name,grocery_categories.cat_name,product_trasfer_delivery.status as deliverystatus');
        $this->db->from('payment_details');
         $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id');
        $this->db->where('payment_details.id', $payid);
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->where('payment_details.order_status', 'DC');
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_deliveryorder($pincode, $deliveryboy_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,product_placed.product_image as product_image,grocery_categories.cat_name,product_trasfer_delivery.status as deliverystatus');
        $this->db->from('payment_details');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id');
        $this->db->where('customer_address.zipcode', $pincode);
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy_id);
        $this->db->where('payment_details.order_status', 'D');
        $this->db->order_by('payment_details.addedon', 'DESC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->result_array();
    }

    function getotpold($payid)
    {
        $sql = "SELECT * FROM `payment_details` WHERE `id`= '$payid' AND `order_status`= 'S' ";
        $que1 = $this->db->query($sql);
        return $que1->row();
    }
    
     function getotp_Return($payid)
    {
        $sql = "SELECT * FROM `payment_details` WHERE `id`= '$payid' AND `order_status`= 'DC' ";
        $que1 = $this->db->query($sql);
        return $que1->row();
    }
    
    
    
    function getotp($payid)
    {
        $sql = "SELECT * FROM `product_trasfer_delivery` WHERE `payid`= '$payid' AND `status`='1' ";
        $que1 = $this->db->query($sql);
        return $que1->row();
    }

    public function Execute($q, $w = [])
    {
        $query = $this->db->query($q, $w);
        if ($query) {
            return $query;
        } else {
            return false;
        }
    }
    public function Insert($table, $f)
    {
        $query = $this->db->insert($table, $f);
        if ($query) {
            $insert_id = $this->db->insert_id();

            return $insert_id;
        } else {
            return false;
        }
    }

    function cheackotp($payid, $otp)
    {
        $sql = "SELECT `otp` FROM `payment_details` WHERE `id`= '$payid' AND `otp`='$otp'";
        $que1 = $this->db->query($sql);
        $output = $que1->num_rows();
        return $output;
    }

    public function select_seller($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_seller');
          $this->db->join('product_trasfer_delivery', 'grocery_seller.seller_id=product_trasfer_delivery.seller_id');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $id);
        $query = $this->db->get();

        return $query->result();
    }

    public function fetch_msg_all()
    {
        $this->db->select('*');
        $this->db->from('chat_system');
        $query = $this->db->get();

        return $query->result();
    }

    public function deliverycountallorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');        
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $query->num_rows();
    }


    public function deliverycountpendingorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');       
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('product_trasfer_delivery.status', '0');
        $this->db->where('payment_details.order_status', 'PCK');
        $this->db->group_by('payment_details.id');    
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function deliveryreturnorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');       
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('product_trasfer_delivery.status', '4');
        $this->db->where('payment_details.order_status', 'R');
        $this->db->group_by('payment_details.id');    
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function deliveryrejectorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');       
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('product_trasfer_delivery.status', '2');        
        $this->db->group_by('payment_details.id');    
        $query = $this->db->get();
        return $query->num_rows();
    }
    

    public function shipping_order($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');       
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.order_status', 'S');
        $this->db->group_by('payment_details.id');    
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function deliverycountdeliverorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.order_status', 'D');
        $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function deliverycountonlinedeliverorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.pay_mode', 'online');
        $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function deliverycountcoddeliverorder($deliveryboy)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.pay_mode', 'COD');
        $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $query->num_rows();
    }  


    public function total_online_coll($deliveryboy)
    {
        $this->db->select('SUM(amount) as total_amount');
        $this->db->from('payment_details');
        // $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        // $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.pay_mode', 'online');
        // $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $result = $query->row(); 
       
    } 

    public function total_cod_coll($deliveryboy)
    {
        $this->db->select('SUM(amount) as total_amount');
        $this->db->from('payment_details');
        // $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        // $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('payment_details.order_status', 'D');
        $this->db->where('payment_details.pay_mode', 'COD');
        // $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $result = $query->row();
          
    } 

    public function total_pen_cod_coll($deliveryboy)
    {
        $this->db->select('SUM(amount) as total_amount');
        $this->db->from('payment_details');
        // $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        // $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);
        $this->db->where('(payment_details.order_status = "P" OR payment_details.order_status = "PR" OR payment_details.order_status = "S" OR payment_details.order_status = "PCK")');
        $this->db->where('payment_details.pay_mode', 'COD');
        // $this->db->group_by('payment_details.id');
        $query = $this->db->get();
        return $query->row();
    }


    public function deliverycountcanceldeliverorder($deliveryboy)
    {
       
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->join('grocery_users', 'grocery_users.id=payment_details.user_id', 'left');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');

        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');

        $this->db->join('grocery_categories', 'grocery_categories.id = grocery_product.cat_id', 'left');

        $this->db->join('product_trasfer_delivery', 'product_trasfer_delivery.payid=payment_details.id', 'left');
      
        $this->db->where('product_trasfer_delivery.deliveryboy_id', $deliveryboy);

        $this->db->where('payment_details.order_status', 'DC');
        $this->db->group_by('payment_details.id');

        $query = $this->db->get();
        return $query->num_rows();
    }

    public function deliveryuser_leave($date)
    {
        $sql = "SELECT * FROM `grocery_deliveryboy` WHERE  leave_status = 0 AND  CURDATE() between lev_start_date and lev_end_date";

        $query = $this->db->query($sql);
        $result = $query->result();
        return $result;
    }

    public function all_notification($seller_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_notification');
        $this->db->where('tbl_notification.add_to', $seller_id);
        $this->db->where('tbl_notification.view_status', 0);
        $this->db->order_by('tbl_notification.id', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    public function count_notification($seller_id)
    {
        $query = $this->db->query("SELECT * FROM tbl_notification WHERE (tbl_notification.add_to = '" . $this->session->userdata('user_login_id') . "' && tbl_notification.view_status = '0')");
        return $query->num_rows();
    }
    public function get_placeid($id)
    {
        $this->db->select('*');
        $this->db->from('product_placed');
        $this->db->where('product_placed.payment_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_payid($id)
    {
        $this->db->select('*');
        $this->db->from('payment_details');
        $this->db->where('payment_details.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }
    public function address($addres)
    {
        $query_customer_address = $this->db->query("SELECT
    *,(SELECT NAME FROM countries WHERE id =customer_address.country ) AS  country_name,(SELECT NAME FROM states WHERE id =customer_address.state ) AS  state_name,(SELECT NAME FROM cities WHERE id =customer_address.city ) AS  city_name FROM customer_address
     WHERE  `customer_address`.id =$addres");
        return $query_customer_address->row_array();
    }
     public function orderorductdelivery($id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,grocery_categories.cat_name,product_placed.product_image as product_image');
        $this->db->from('payment_details');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('grocery_seller', 'grocery_seller.seller_id=grocery_product.sellar_id', 'left');

        $this->db->where('payment_details.id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function get_deliveryuser($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_deliveryboy');
        $this->db->where('deli_user_id', $id);

        $query = $this->db->get();
        return $query->row();
    }
    
     function set_notification_status($id,$status) {
        $this->db->where('id', $id);
        $this->db->update('tbl_notification', array('view_status' => $status));
    }
    
    
   
}
