<?php
class Deliveryboy_model extends CI_Model
{
    
    
 public function getDashboardCounts($deliveryboy_id ,$service_id='')
{
    $this->food_db->select("
        COUNT(CASE WHEN status = 0 THEN 1 END) AS new_order,
        COUNT(CASE WHEN status = 1 THEN 1 END) AS ongoing_order,
        COUNT(CASE WHEN status = 3 THEN 1 END) AS completed_order,
        COUNT(CASE WHEN status = 5 THEN 1 END) AS cancel_order,
        COUNT(CASE WHEN (status = 3   OR status = 1  OR status = 0) THEN 1 END) AS total_order,
        COUNT(CASE WHEN collect_mode = 1 AND (status = 3 OR status = 1) THEN 1 END) AS cod_order,
        SUM(CASE WHEN collect_mode = 1 THEN offline_collect ELSE 0 END) AS collect_amount
    ");
    
    $this->food_db->where('deliveryboy_id', $deliveryboy_id);
    
    if(!empty($service_id)){
        
     $this->food_db->where('service_id', $service_id);
    }
    

    
    return $this->food_db->get('product_trasfer_delivery')->row_array();
}





public function get_order_summary($payid)
    {
        $order = $this->food_db->select('
                pd.id AS payid,
                pd.order_id,
                pd.user_id,
                pd.phone,
                pd.pay_mode,
                pd.preamount AS total_amount,
                pd.order_status,
                pd.created,
                u.name AS user_name,
                ca.per_add AS address,
                s.store_name,
                s.address AS sel_address
            ')
            ->from('payment_details pd')
            ->join('users u', 'u.id = pd.user_id')
            ->join('customer_address ca', 'ca.id = pd.address1')
            ->join('seller s', 's.seller_id = pd.seller_id')
            ->where('pd.id', $payid)
            ->get()
            ->row_array();

        if (!$order) return false;

        $products = $this->food_db->select('
                pp.id AS product_place_id,
                pp.product_name,
                pp.discount,
                pp.net_price,
                pp.admin_profit,
                pp.product_price,
                pp.product_qty,
                pp.product_weight,
                pp.addons,
                pp.product_image,
                pp.delivered_date
            ')
            ->from('product_placed pp')
            ->where('pp.payment_id', $payid)
            ->get()
            ->result_array();

        $product_list = array_map(function ($prod) {
            return [
                'product_place_id' => $prod['product_place_id'],
                'product_name'     => $prod['product_name'],
                'product_price'    => $prod['product_price'],
                'discount'         => $prod['discount'],
                'net_price'        => $prod['net_price'],
                'admin_profit'     => $prod['admin_profit'],
                'quantity'         => $prod['product_qty'],
                'weight'           => $prod['product_weight'],
                'addons'           => json_decode($prod['addons'], true) ?: [],
                'product_image'    => base_url('uploads/products/' . $prod['product_image']),
            ];
        }, $products);

        return [
            'order_id'         => $order['order_id'],
            'user_name'        => $order['user_name'],
            'phone'            => $order['phone'],
            'customer_address' => $order['address'],
            // 'delivered_date'   => $products['delivered_date'],
            'sel_address'      => $order['sel_address'],
            'sel_name'         => $order['store_name'],
            'payment_mode'     => $order['pay_mode'],
            'order_status'     => $order['order_status'],
            'total_amount'     => $order['total_amount'],
            'order_date'       => date('d M Y, h:i A', strtotime($order['created'])),
            'products'         => $product_list
        ];
    }











public function getRow($table, $where = [])
{
    return $this->food_db->get_where($table, $where)->row_array();
}


    public function getActiveServices()
    {
        $img_url = FOOD_IMAGE_URL;
        $this->food_db->select('id, service_name, service_img');
        $this->food_db->where('status', 1);
        $services_raw = $this->food_db->get('all_services')->result_array();

        foreach ($services_raw as &$service) {
            $service['service_img'] = $img_url . $service['service_img'];
        }

        return $services_raw;
    }
    
    
    
    
    
    
    
    
    public function getOrdersByStatus($deliveryboy_id, $status)
{
    
   
    $limit = 10;
   

    $this->food_db->select(
        "pd.id AS payid, pd.order_id, pd.user_id,pd.seller_id as seller_id, u.name AS customer_name,u.user_id as customer_id , pd.pay_mode,ser.service_name ,
        pd.preamount AS amount, pd.phone, ca.per_add AS cust_address, ca.latitude AS cust_lat,
        ca.longitude AS cust_lng,ca.landMark as drop_landmark, ca.locality as drop_locality ,ca.country as drop_country ,ca.state as drop_state ,ca.district as drop_district , ca.city as drop_city ,ca.zipcode as drop_pincode ,ca.address_name as address_type , ptd.deliveryboy_id, 
        pp.product_name, pp.product_image, pp.product_price, pp.discount,
        pp.product_qty, pp.net_price, pp.product_weight, pd.order_status, pd.created,s.Pincode as pickup_pincode  , s.locality as pickup_locality ,s.landmark as pickup_landmark,s.state as pickup_state ,s.city as pickup_city  ,s.district  as pickup_district,s.country as pickup_country, 
        s.address AS seller_address ,s.seller_name ,s.longitude as sel_longitude ,s.latitude as sel_latitude"
    );
    $this->food_db->from('payment_details pd');
    $this->food_db->join('users u', 'u.id = pd.user_id');
    $this->food_db->join('customer_address ca', 'ca.user_id = u.id', 'left');
    $this->food_db->join('product_trasfer_delivery ptd', 'pd.id = ptd.payid', 'left');
    $this->food_db->join('product_placed pp', 'pd.id = pp.payment_id','inner');
    $this->food_db->join('seller s', 's.seller_id = pd.seller_id', 'inner');
    $this->food_db->join('all_services ser', 'pd.service_id = ser.id','inner') ;

    $this->food_db->where('ptd.deliveryboy_id', $deliveryboy_id);
    $this->food_db->where('ptd.status', $status);
    
  
 $this->food_db->group_by('pd.id');
    $this->food_db->order_by('pd.id', 'DESC');
    $this->food_db->limit($limit);

    $result = $this->food_db->get()->result_array();

    $orders = [];
    foreach ($result as $row) {
        $payid = $row['payid'];

        if (!isset($orders[$payid])) {
            
            
             $lat1 = floatval($row['sel_latitude']);
        $lon1 = floatval($row['sel_longitude']);
        $lat2 = floatval($row['cust_lat']);
        $lon2 = floatval($row['cust_lng']);
        
         // Radius of Earth in km
        $earthRadius = 6371;

        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) +
             cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
             sin($dLon / 2) * sin($dLon / 2);

        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $earthRadius * $c;
        
        
         // Estimate time in minutes assuming average speed of 30 km/h
        $avgSpeed = 30; // km/h
        $time = ($distance / $avgSpeed) * 60; // in minutes
            
            
            
            
            
            $orders[$payid] = [
                'service_name' => $row['service_name'],
                'payid' => $row['payid'],
                'order_id' => $row['order_id'],
                'user_id' => $row['customer_id'],
                'customer_name' => $row['customer_name'],
                
                'pay_mode' => $row['pay_mode'],
                'amount' => $row['amount'],
                'order_status' => $row['order_status'],
                'phone' => $row['phone'],
                'cust_address' => $row['cust_address'],
                'cust_lat' => $row['cust_lat'],
                'cust_lng' => $row['cust_lng'],
                'sel_lat' => $row['sel_latitude'],
                'sel_lng' => $row['sel_longitude'],
                'distance_km' => round($distance, 2),
            'estimated_time_min' => round($time),
                'created' => $row['created'],
                'seller_address' => $row['seller_address'],
                'seller_id' => $row['seller_id'],
                 'seller_name' => $row['seller_name'],
                'pickup_location' => [] ,
                'delivery_location' => [] ,
                'products' => [],
                '_product_keys' => [],
            ];
            
            
            
            $orders[$payid]['pickup_location'] = [
                
                
    'lat' => isset($row['sel_latitude']) ? (float) $row['sel_latitude'] : null,
    'lng' => isset($row['sel_longitude']) ? (float) $row['sel_longitude'] : null,
    'address' => $row['seller_address'] ?? '',
    'pincode' => $row['pickup_pincode'] ?? '',
    'locality' => $row['pickup_locality'] ?? '',
    'buildingNumber' =>  '',
    'city' => $row['pickup_city'] ?? '',
    'state' => $row['pickup_state'] ?? '',
    'district' => $row['pickup_district'] ?? '',
    'country' => $row['pickup_country'] ?? ''
];

         $orders[$payid]['delivery_location'] = [
                
      'lat' => isset($row['cust_lat']) ? (float) $row['cust_lat'] : null,
    'lng' => isset($row['cust_lng']) ? (float) $row['cust_lng'] : null,
    'address' => $row['cust_address'] ?? '',
     'address_type' => $row['address_type'] ?? '',
    'pincode' => $row['drop_pincode'] ?? '',
    'locality' => $row['drop_locality'] ?? '',
    'buildingNumber' =>  '',
    'city' => $row['drop_city'] ?? '',
    'state' => $row['drop_state'] ?? '',
    'district' => $row['drop_district'] ?? '',
    'country' => $row['drop_country'] ?? ''
];      
            
            
            
            
            
            
            
            
            
            
            
        }
        
        
        
        

        $key = crc32($row['product_name'] . $row['product_image'] . $row['product_price'] . $row['discount'] . $row['product_qty'] . $row['net_price'] . $row['product_weight']);

        if (!isset($orders[$payid]['_product_keys'][$key])) {
            $orders[$payid]['products'][] = [
                'product_name' => $row['product_name'],
                'qty' => $row['product_qty']
            ];
            $orders[$payid]['_product_keys'][$key] = true;
        }
    }

    foreach ($orders as &$order) {
        unset($order['_product_keys']);
    }

   return array_values($orders);
}



 public function getOrdersByStatus_New($deliveryboy_id, $status,$service,$limit = 10, $offset = 0)
{
    
   
   
   

    $this->food_db->select(
        "pd.id AS payid, pd.order_id, pd.user_id,pd.seller_id as seller_id, u.name AS customer_name,u.user_id as customer_id , pd.pay_mode,ser.service_name ,
        pd.preamount AS amount, pd.phone, ca.per_add AS cust_address, ca.latitude AS cust_lat,
        ca.longitude AS cust_lng,ca.landMark as drop_landmark, ca.locality as drop_locality ,ca.country as drop_country ,ca.state as drop_state ,ca.district as drop_district , ca.city as drop_city ,ca.zipcode as drop_pincode ,ca.address_name as address_type , ptd.deliveryboy_id, 
        pp.product_name, pp.product_image, pp.product_price, pp.discount,
        pp.product_qty, pp.net_price, pp.product_weight, pd.order_status, pd.created,s.Pincode as pickup_pincode  , s.locality as pickup_locality ,s.landmark as pickup_landmark,s.state as pickup_state ,s.city as pickup_city  ,s.district  as pickup_district,s.country as pickup_country, 
        s.address AS seller_address ,s.seller_name ,s.longitude as sel_longitude ,s.latitude as sel_latitude"
    );
    $this->food_db->from('payment_details pd');
    $this->food_db->join('users u', 'u.id = pd.user_id');
    $this->food_db->join('customer_address ca', 'ca.user_id = u.id', 'left');
    $this->food_db->join('product_trasfer_delivery ptd', 'pd.id = ptd.payid', 'left');
    $this->food_db->join('product_placed pp', 'pd.id = pp.payment_id','inner');
    $this->food_db->join('seller s', 's.seller_id = pd.seller_id', 'inner');
    $this->food_db->join('all_services ser', 'pd.service_id = ser.id','inner') ;

     $this->food_db->where('ptd.deliveryboy_id', $deliveryboy_id);
    $this->food_db->where('ptd.status', $status);
    $this->food_db->where('pd.service_id', $service);
    $this->food_db->order_by('pd.id', 'DESC');
    $this->food_db->limit($limit,$offset);


    $result = $this->food_db->get()->result_array();

    $orders = [];
    foreach ($result as $row) {
        $payid = $row['payid'];

        if (!isset($orders[$payid])) {
            
            
             $lat1 = floatval($row['sel_latitude']);
        $lon1 = floatval($row['sel_longitude']);
        $lat2 = floatval($row['cust_lat']);
        $lon2 = floatval($row['cust_lng']);
        
         // Radius of Earth in km
        $earthRadius = 6371;

        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) +
             cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
             sin($dLon / 2) * sin($dLon / 2);

        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $earthRadius * $c;
        
        
         // Estimate time in minutes assuming average speed of 30 km/h
        $avgSpeed = 30; // km/h
        $time = ($distance / $avgSpeed) * 60; // in minutes
            
            
            
            
            
            $orders[$payid] = [
                'service_name' => $row['service_name'],
                'payid' => $row['payid'],
                'order_id' => $row['order_id'],
                'user_id' => $row['customer_id'],
                'customer_name' => $row['customer_name'],
                
                'pay_mode' => $row['pay_mode'],
                'amount' => $row['amount'],
                'order_status' => $row['order_status'],
                'phone' => $row['phone'],
                'cust_address' => $row['cust_address'],
                'cust_lat' => $row['cust_lat'],
                'cust_lng' => $row['cust_lng'],
                'sel_lat' => $row['sel_latitude'],
                'sel_lng' => $row['sel_longitude'],
                'distance_km' => round($distance, 2),
            'estimated_time_min' => round($time),
                'created' => $row['created'],
                'seller_address' => $row['seller_address'],
                'seller_id' => $row['seller_id'],
                 'seller_name' => $row['seller_name'],
                'pickup_location' => [] ,
                'delivery_location' => [] ,
                'products' => [],
                '_product_keys' => [],
            ];
            
            
            
            $orders[$payid]['pickup_location'] = [
                
                
    'lat' => isset($row['sel_latitude']) ? (float) $row['sel_latitude'] : null,
    'lng' => isset($row['sel_longitude']) ? (float) $row['sel_longitude'] : null,
    'address' => $row['seller_address'] ?? '',
    'pincode' => $row['pickup_pincode'] ?? '',
    'locality' => $row['pickup_locality'] ?? '',
    'buildingNumber' =>  '',
    'city' => $row['pickup_city'] ?? '',
    'state' => $row['pickup_state'] ?? '',
    'district' => $row['pickup_district'] ?? '',
    'country' => $row['pickup_country'] ?? ''
];

         $orders[$payid]['delivery_location'] = [
                
      'lat' => isset($row['cust_lat']) ? (float) $row['cust_lat'] : null,
    'lng' => isset($row['cust_lng']) ? (float) $row['cust_lng'] : null,
    'address' => $row['cust_address'] ?? '',
     'address_type' => $row['address_type'] ?? '',
    'pincode' => $row['drop_pincode'] ?? '',
    'locality' => $row['drop_locality'] ?? '',
    'buildingNumber' =>  '',
    'city' => $row['drop_city'] ?? '',
    'state' => $row['drop_state'] ?? '',
    'district' => $row['drop_district'] ?? '',
    'country' => $row['drop_country'] ?? ''
];      
            
            
            
            
            
            
            
            
            
            
            
        }
        
        
        
        

        $key = crc32($row['product_name'] . $row['product_image'] . $row['product_price'] . $row['discount'] . $row['product_qty'] . $row['net_price'] . $row['product_weight']);

        if (!isset($orders[$payid]['_product_keys'][$key])) {
            $orders[$payid]['products'][] = [
                'product_name' => $row['product_name'],
                'qty' => $row['product_qty']
            ];
            $orders[$payid]['_product_keys'][$key] = true;
        }
    }

    foreach ($orders as &$order) {
        unset($order['_product_keys']);
    }

   return array_values($orders);
}

     public function getOrdersByStatus_New_old($deliveryboy_id, $status,$service,$limit = 10, $offset = 0)
    {
    

   

    $this->food_db->select(
        "pd.id AS payid, pd.order_id, pd.user_id, u.name AS customer_name, pd.pay_mode,
        pd.preamount AS amount, pd.phone, ca.per_add AS cust_address, ca.latitude AS cust_lat,
        ca.longitude AS cust_lng, ptd.deliveryboy_id, 
        pp.product_name, pp.product_image, pp.product_price, pp.discount,
        pp.product_qty, pp.net_price, pp.product_weight, pd.order_status, pd.created,
        s.address AS seller_address ,s.longitude as sel_longitude ,s.latitude as sel_latitude"
    );
    $this->food_db->from('payment_details pd');
    $this->food_db->join('users u', 'u.id = pd.user_id');
    $this->food_db->join('customer_address ca', 'ca.user_id = u.id', 'left');
    $this->food_db->join('product_trasfer_delivery ptd', 'pd.id = ptd.payid', 'left');
    $this->food_db->join('product_placed pp', 'pd.id = pp.payment_id','inner');
    $this->food_db->join('seller s', 's.seller_id = pd.seller_id', 'left');

    $this->food_db->where('ptd.deliveryboy_id', $deliveryboy_id);
    $this->food_db->where('ptd.status', $status);
    $this->food_db->where('pd.service_id', $service);
    $this->food_db->order_by('pd.id', 'DESC');
    $this->food_db->limit($limit,$offset);

    $result = $this->food_db->get()->result_array();

    $orders = [];
    foreach ($result as $row) {
        $payid = $row['payid'];
        
        
        

        if (!isset($orders[$payid])) {
            
            
             $lat1 = floatval($row['sel_latitude']);
        $lon1 = floatval($row['sel_longitude']);
        $lat2 = floatval($row['cust_lat']);
        $lon2 = floatval($row['cust_lng']);
            
             // Radius of Earth in km
        $earthRadius = 6371;

        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);

        $a = sin($dLat / 2) * sin($dLat / 2) +
             cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
             sin($dLon / 2) * sin($dLon / 2);

        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $earthRadius * $c;
        
        
        
         // Estimate time in minutes assuming average speed of 30 km/h
        $avgSpeed = 30; // km/h
        $time = ($distance / $avgSpeed) * 60; // in minutes
            
            
            
            $orders[$payid] = [
                'payid' => $row['payid'],
                'order_id' => $row['order_id'],
                'user_id' => $row['user_id'],
                'customer_name' => $row['customer_name'],
                'pay_mode' => $row['pay_mode'],
                'amount' => $row['amount'],
                'order_status' => $row['order_status'],
                'phone' => $row['phone'],
                'cust_address' => $row['cust_address'],
                'cust_lat' => $row['cust_lat'],
                'cust_lng' => $row['cust_lng'],
                'sel_lat' => $row['sel_latitude'],
                'sel_lng' => $row['sel_longitude'],
                'distance_km' => (double) round((float) ($distance ?? 0), 2),
            'estimated_time_min' => round($time),
                'created' => $row['created'],
                'seller_address' => $row['seller_address'],
                'products' => [],
                '_product_keys' => [],
            ];
        }

        $key = crc32($row['product_name'] . $row['product_image'] . $row['product_price'] . $row['discount'] . $row['product_qty'] . $row['net_price'] . $row['product_weight']);

        if (!isset($orders[$payid]['_product_keys'][$key])) {
            $orders[$payid]['products'][] = [
                'product_name' => $row['product_name'],
                'qty' => $row['product_qty']
            ];
            $orders[$payid]['_product_keys'][$key] = true;
        }
    }

    foreach ($orders as &$order) {
        unset($order['_product_keys']);
    }

   return array_values($orders);
}
    
   

    public function countOrdersByStatus($deliveryboy_id , $status ,$service_id='')
{
    $this->food_db->from('payment_details pd');
    $this->food_db->join('product_trasfer_delivery ptd', 'pd.id = ptd.payid', 'left');

    $this->food_db->where('ptd.deliveryboy_id', $deliveryboy_id);
    if(!empty($service_id)){
    $this->food_db->where('pd.service_id', $service_id);
    }
    
    $this->food_db->where('ptd.status', $status);

    return $this->food_db->count_all_results();
}
    
    
    
    
    
    

    
}
