<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include Razorpay SDK
require_once APPPATH . 'third_party/razorpay/Razorpay.php';

use Razorpay\Api\Api;

class Razorpay {

    private $api;

    public function __construct() {
        $key_id = 'rzp_test_rkEEf9GKtGHN9E';
		$key_secret = 'tgiT3ELZQSBG4cDExoASvoNe';
        $this->api = new Api($key_id, $key_secret);
    }


    public function create_order($amount, $receipt_id) {
        try {
            $order = $this->api->order->create([
                'receipt' => $receipt_id,
                'amount' => $amount * 100,
                'currency' => 'INR',
                'payment_capture' => 1
            ]);

            return [
                'status' => 'success',
                'order_id' => $order['id'],
                'amount' => $order['amount'],
                'currency' => $order['currency'],
				'message'=>'Order created successfully'
            ];
        } catch (Exception $e) {
			return [
                'status' => 'error',
                'order_id' => '',
                'amount' => '',
                'currency' => '',
				'message'=>$e->getMessage()
            ];
        }
    }

  
    public function verify_payment($order_id, $payment_id, $signature) {
        try {
            $attributes = [
                'razorpay_order_id' => $order_id,
                'razorpay_payment_id' => $payment_id,
                'razorpay_signature' => $signature
            ];

            $this->api->utility->verifyPaymentSignature($attributes);
            return ['status' => 'success', 'message' => 'Payment verified'];
        } catch (Exception $e) {
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }
}
