<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    public function __construct(){
        
		parent::__construct();
		
		$this->load->helper('email'); 
		
        $sql =  "SELECT * FROM tbl_api_auth";
        $api_auth= $this->db->query($sql)->row_array();

        if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
        {
            header("Access-Control-Allow-Origin: *");
            header("Content-Type: application/json; charset=UTF-8");
            $response['status']='error';
            $response['statusCode']=400;
            $response['message']='Authentication failed';
            echo json_encode($response);
            die;
        }
 
    }
    
    
    
    public function getvehicle()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		
		
		 if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
			
		$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
		$pickup_lat=$data->pickup_lat;
		$pickup_long=$data->pickup_long;
	    $drop_lat=$data->drop_lat;
		$drop_long=$data->drop_long;
		
		if($pickup_lat && $pickup_long && $drop_lat && $drop_long)
		{
		    $get_hours=date('H');
		    
		    $qry="SELECT tmp.*,vt.id,vt.image,vt.name,vt.description,f.per_km FROM (SELECT driver_id,
    	    round(( 6371 * acos( cos( radians(round($pickup_lat,2)) ) * cos( radians(curr_lat) ) *
            cos( radians(curr_long) - radians(round($pickup_long,2)) ) + sin( radians(round($pickup_lat,2)) ) * sin( radians(curr_lat) ) ) )) AS distance
    	    FROM tbl_driver_currentLocation d GROUP BY driver_id) AS tmp
    	    INNER JOIN tbl_driver d ON d.id=tmp.driver_id
    	    INNER JOIN tbl_vehicle tv ON tv.driver_id=d.id
     	    INNER JOIN tbl_map_vehicletype dmt ON dmt.vehicle_id=tv.id
     	    INNER JOIN tbl_vehicletype vt ON vt.id=dmt.type_id
     	    INNER JOIN tbl_fare f ON f.vehicle_type=vt.id WHERE vt.status=1 AND d.is_online=1 AND d.status=1 AND tmp.distance <= '".DEFAULT_NEARBY_DRIVER_AREA."' GROUP BY vt.id ORDER BY tmp.distance,f.per_km ASC";
    	    
    	    $result=$this->db->query($qry)->result_array();
    	    if(!empty($result))
    	    {
    	        $total_distance=$this->distance($pickup_lat,$pickup_long,$drop_lat,$drop_long,'K');
    	        
    	        $i=0;
    	        foreach($result as $row)
    	        {
    	            $response['vehicle'][$i]['id']=$row['id'];
    	            $response['vehicle'][$i]['name']=$row['name'];
    	            $response['vehicle'][$i]['image']=base_url().$row['image'];
    	            $response['vehicle'][$i]['description']=$row['description'];
    	            
    	            if($total_distance > 0) 
    	            {
    	                $response['vehicle'][$i]['fare']=round($total_distance*$row['per_km'],2);
    	            }
    	            else
    	            {
    	                $response['vehicle'][$i]['fare']=$row['per_km'];
    	            }
    	            
    	           
    	            
    	            $i++;
    	        }
    	        
    	        
    	        $status='success';
                $message='Data found';
                $statusCode=200;   
    	        
    	    }
    	    else
    	    {
    	        $status='error';
                $message='No any cab found near by you';
                $statusCode=400;     
    	    }
		}
		else
		{
		    $status='error';
            $message='Please fill in all required fields.';
            $statusCode=400;        
           
		}
		
		 }else{
		     	$status='error';
        $message='Invalid Request';
        $statusCode=400;
		 }
		$response['status']=$status;
		$response['message']=$message;
		$response['statusCode']=$statusCode;
		echo json_encode($response);
    }
    
    
    public function sendReqForfindDriver()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		
		$status='error';
        $message='Invalid Request';
        $statusCode=400;
			
		$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
		$pickup_lat=$data->pickup_lat;
		$pickup_long=$data->pickup_long;
	    $drop_lat=$data->drop_lat;
		$drop_long=$data->drop_long;
		$vehicle_type_id=$data->vehicle_type_id;
		$user_id=$data->user_id;
		$added_by_web=$data->added_by_web;
		
		$pickup_address=$data->pickup_address;
		$drop_address=$data->drop_address;
		
		
		if($pickup_lat && $pickup_long && $drop_lat && $drop_long && $vehicle_type_id && $pickup_address && $drop_address)
		{
		    $this->db->where('user_id',$user_id);
		    $this->db->update('tbl_userwise_cabrequest',array('is_latest_request'=>0));
		    
		    $qry="SELECT tmp.*,dmt.type_id,f.per_km,d.f_token_app,TIMESTAMPDIFF(MINUTE,d.accepted_request_time,NOW()) as driverreq_accepted_time FROM(SELECT driver_id,
    	    round(( 6371 * acos( cos( radians(round($pickup_lat,2)) ) * cos( radians(curr_lat) ) *
            cos( radians(curr_long) - radians(round($pickup_long,2)) ) + sin( radians(round($pickup_lat,2)) ) * sin( radians(curr_lat) ) ) )) AS distance
    	    FROM tbl_driver_currentLocation d GROUP BY driver_id) AS tmp
    	    INNER JOIN tbl_driver d ON d.id=tmp.driver_id
    	    INNER JOIN tbl_vehicle tv ON tv.driver_id=d.id
     	    INNER JOIN tbl_map_vehicletype dmt ON dmt.vehicle_id=tv.id
     	    INNER JOIN tbl_fare f ON f.vehicle_type=dmt.type_id
     	    WHERE d.is_online=1 AND d.status=1 AND dmt.type_id=$vehicle_type_id AND tmp.distance <= ".DEFAULT_NEARBY_DRIVER_AREA." ORDER BY tmp.distance ASC";
	        
		    $result=$this->db->query($qry)->result_array();
		    
		    if(!empty($result))
		    {
		        $total_distance=$this->distance($pickup_lat,$pickup_long,$drop_lat,$drop_long,'K');
    	        $request_id='REQ-'.sprintf("%08d", mt_rand(0, 999999));
    	        
    	        
		        foreach($result as $row)
    	        {
    	           // if($row['driverreq_accepted_time'] > REQUESTEXPIRE_TIME)
    	           // {
        	            $data=array(
        	                 'req_id'=>$request_id,
        	                 'pickup_address'=>$pickup_address,
        	                 'drop_address'=>$drop_address,
        	                 'pickup_lat'=>$pickup_lat,
        	                 'pickup_long'=>$pickup_long,
        	                 'drop_lat'=>$drop_lat,
        	                 'drop_long'=>$drop_long,
        	                 'user_id'=>$user_id,
        	                 'driver_id'=>$row['driver_id'],
        	                 'type_id'=>$row['type_id'],
        	                 'driver_away'=>$row['distance'],
        	                 'user_journey_distance'=>round($total_distance,2),
        	                 'per_km_fare'=>$row['per_km'],
        	                 'entry_date'=>date('Y-m-d H:i:s'),
        	                 'added_by_web'=>$added_by_web,
        	                );
        	            $this->db->insert('tbl_userwise_cabrequest',$data);
        	            
        	           
        	            if($row['f_token_app'])
        	            {
            	            //send notification
            	            $body="You have received a new ride request of pickup locaion ".$pickup_address." from a user .";
            	            $title="New Ride Request";
            	            sendNotificationFlutter($row['f_token_app'],$body,$title);
        	            }
        	            
        	           
    	           // }
    	        }
    	        
    	        
    	        $response['vehicle_type_id']=$vehicle_type_id;
    	        $status='success';
                $message='Request has been send successfully';
                $statusCode=200;
		    }
		    else
		    {
		        $status='error';
                $message='No any driver found near by you.';
                $statusCode=400;     
		    }
		}
		else
		{
		    $status='error';
            $message='Please fill in all required fields.';
            $statusCode=400;        
           
		}
		$response['status']=$status;
		$response['message']=$message;
		$response['statusCode']=$statusCode;
		echo json_encode($response);
    }
    
    
    public function findDriver()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		
		$status='error';
        $message='Invalid Request';
        $statusCode=400;
			
		$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $vehicle_type_id=$data->vehicle_type_id;
		$user_id=$data->user_id;
        if($vehicle_type_id && $user_id)
        {
            $qry="SELECT d.*,r.id as requestid,r.driver_away,r.user_journey_distance,r.per_km_fare,r.pickup_address,r.drop_address, 
            r.pickup_lat,r.pickup_long,r.drop_lat,r.drop_long,vt.name as vehiclename,vt.image as vehicleimage
            FROM tbl_userwise_cabrequest r
            INNER JOIN tbl_driver d ON d.id=r.driver_id
            INNER JOIN tbl_vehicletype vt ON vt.id=r.type_id
            WHERE r.user_id=$user_id AND r.type_id=$vehicle_type_id AND r.status=1 AND r.is_latest_request=1 ORDER BY id ASC";
            
            $result=$this->db->query($qry)->row_array();
            
            if(!empty($result))
            {
                $response['send_request_id']=$result['requestid'];
                $response['pickup_address']=$result['pickup_address'];
                $response['pickup_lat']=$result['pickup_lat'];
                $response['pickup_long']=$result['pickup_long'];
                $response['drop_address']=$result['drop_address'];
                $response['drop_lat']=$result['drop_lat'];
                $response['drop_long']=$result['drop_long'];
                
                $response['driver_name']=$result['driver_name'];
                $response['driver_id']=$result['driver_id'];
                $response['mobile_no']=$result['mobile_no'];
                $response['driver_profile_pic']=base_url().$result['driver_profile_pic'];
                $response['email']=$result['email'];
                $response['driver_away']=(int)$result['driver_away'];
                $response['user_journey_distance']=(int)$result['user_journey_distance'];
                $response['total_fare']=(int)round($result['user_journey_distance']*$result['per_km_fare'],2);
                
                $response['vehicle_name']=$result['vehiclename'];
                $response['vehicle_image']=base_url().$result['vehicleimage'];
                $status='success';
                $message='success';
                $statusCode=200;  
            }
            else
            {
                $status='error';
                $message='Request not accept from driver side.';
                $statusCode=400;  
            }
        }
        else
        {
            $status='error';
            $message='Please fill in all required fields.';
            $statusCode=400;  
        }
        $response['status']=$status;
		$response['message']=$message;
		$response['statusCode']=$statusCode;
		echo json_encode($response);
    }
    
    public function distance($lat1, $lon1, $lat2, $lon2, $unit) {
      if (($lat1 == $lat2) && ($lon1 == $lon2)) {
        return 0;
      }
      else {
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);
    
        if ($unit == "K") {
          return ($miles * 1.609344);
        } else if ($unit == "N") {
          return ($miles * 0.8684);
        } else {
          return $miles;
        }
      }
    }
    
    public function paynow()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $send_request_id=$data->send_request_id;
    	$added_by_web=$data->added_by_web;
    	$user_id=$data->user_id;
    	$paymenttype=$data->paymenttype;
    	$conv_charge=$data->conv_charge;
    	if($send_request_id && $added_by_web && $user_id && $paymenttype)
    	{
    	    $qry="SELECT * FROM tbl_userwise_cabrequest WHERE id='$send_request_id' AND status=1 AND is_latest_request=1";
            $row=$this->db->query($qry)->row_array();
            
            if(!empty($row))
            {
    	        $order_id=$this->generateOrderID($row['user_id']);
                $trans_id='';
                $booking_id='Book-'.sprintf("%08d", mt_rand(0, 999999));
                
                 
                $total_payble=round($row['per_km_fare']*$row['user_journey_distance'],2);     
                
                if($paymenttype == 'online')
                {
                    $trans_id=$this->generateTransID();
                    
                    $total_payble=round($total_payble+$conv_charge);
                    
                    $login_user=array(
        	            'booking_id'=>$booking_id,
                        'user_id'=>$user_id,
                        'order_id'=>$order_id,
                        'trans_id'=>$trans_id,
                        'payment_type'=>'online',
                        'trans_amount'=>$total_payble,
                        'conv_charge'=>$conv_charge,
                        'added_by_web'=>$added_by_web,
                        'ip'=>$_SERVER["REMOTE_ADDR"],
                        'entry_date'=>date('Y-m-d H:i:s'),
                    );
                    
                    $this->db->insert('tbl_user_trans',$login_user);
                }
                else
                {
                    $conv_charge=0; 
                }
                $response['order_id']=$order_id;
                $response['MID']="";
                $response['WEB_CALLBACK_URL']="";
                
                $response['CONV_CHARGE']=(int)$conv_charge;
                $response['MAIN_AMOUNT']=$total_payble-$conv_charge;
                $response['TXN_AMOUNT']=$total_payble;
                $response['CUST_ID']=$trans_id;
                $response['booking_id']=$booking_id;
                $response['payment_type']=$paymenttype;
    
                $status='success';
                $message='success';
                $statusCode=200;
    	    }
    	    else
    	    {
    	        $status='error';
                $message='This booking not valid for payment';
                $statusCode=400;  
    	    }
    	}
    	else
    	{
    	    $status='error';
            $message='Booking id required';
            $statusCode=400;    
    	}
    	
        $response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    
    
    
       // Order ID
    public function generateOrderID($user_id=NULL)
     {   
         $current_timestamp_by_mktime = mktime(date("H"),date("i"),date("s"),date("m"),date("d"),date("Y"));
         $ord_id="ORDCAB-".$user_id."~".$current_timestamp_by_mktime ;  
    
         $lenth = strlen($ord_id);
         if($lenth >= 30){
             $ord_id = substr($ord_id,0,29);
         }
         
        return $ord_id;
    
     }
     
    
      
    //tarnasction ID
    public function generateTransID()
    {
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        $tran_id = "TRANSCAB-".substr($str_result,0,1)."SEND".rand(10,99999999999) ;
        
        $lenth = strlen($tran_id);
        
        if($lenth >= 30){
            $tran_id = substr($tran_id,0,29);
        }
        
        return $tran_id;
    }
    
    public function payment_verify()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $orderno=$data->orderno;
        $tarns_id=$data->tarns_id;
        $TXN_AMOUNT=$data->TXN_AMOUNT;
        $user_id=$data->user_id;
       

        if(isset($orderno) && isset($tarns_id) && isset($TXN_AMOUNT) && isset($user_id))
        {
            $check_payment=$this->db->query("SELECT * FROM tbl_user_trans WHERE order_id='$orderno' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0")->row_array();

            if(!empty($check_payment))
            {
                $response['payment_verify']=true;
                
                // $this->db->query("UPDATE tbl_user_trans SET status=1 WHERE order_id='$orderno' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0");
                
                // $this->db->query("UPDATE tbl_booking SET payment_status=1 WHERE book_id='".$check_payment['booking_id']."'");
            }
            else
            {
                $response['payment_verify']=false;
            }

            $status='success';
            $message='success';
            $statusCode=200;
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    
    public function Bookcab()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		
		$status='error';
        $message='Invalid Request';
        $statusCode=400;
			
		$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $send_request_id=$data->send_request_id;
		$user_id=$data->user_id;
		$added_by_web=$data->added_by_web;
		$booking_id=$data->booking_id;
		$paymenttype=$data->paymenttype;
		
		$order_id=$data->order_id;
        $tarns_id=$data->tarns_id;
        $TXN_AMOUNT=$data->TXN_AMOUNT;
        $conv_charge=$data->conv_charge;
        $phone=$data->user_phone;
        if($send_request_id && $user_id && $booking_id && $paymenttype && $order_id && $TXN_AMOUNT && $phone)
        {
            
            if($paymenttype=='online')
            {
                $check_payment=$this->db->query("SELECT * FROM tbl_user_trans WHERE order_id='$order_id' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0")->row_array();
            }
            else
            {
                $check_payment=array('paymode'=>'other');
            }
               
              
            if(!empty($check_payment))    
            {
                $qry="SELECT * FROM tbl_userwise_cabrequest WHERE id='$send_request_id' AND status=1 AND is_latest_request=1";
                $row=$this->db->query($qry)->row_array();
                
                if(!empty($row))
                {
                    
                    if($paymenttype=='online')
                    {
                       $pay_mode='online';
                       $payment_status=1;
                    }
                    else if($paymenttype=='wallet')
                    {
                       $pay_mode='wallet';
                       $payment_status=1;
                    }
                    else
                    {
                       $pay_mode='COD';
                       $payment_status=0;
                    }
                   
                    $data=array(
                        'book_id'=>$booking_id,
                        'order_id'=>$order_id,
                        'trans_id'=>$tarns_id,
                        'user_id'=>$user_id,
                        'driver_id'=>$row['driver_id'],
                        'pickup_address'=>$row['pickup_address'],
                        'pickup_lat'=>$row['pickup_lat'],
                        'pickup_long'=>$row['pickup_long'],
                        'drop_address'=>$row['drop_address'],
                        'drop_lat'=>$row['drop_lat'],
                        'drop_long'=>$row['drop_long'],
                        'type_id'=>$row['type_id'],
                        'driver_away'=>$row['driver_away'],
                        'send_request_id'=>$row['id'],
                        'user_journey_distance'=>round($row['user_journey_distance'],2),
                        'per_km_fare'=>$row['per_km_fare'],
                        'total_fare'=>round($row['per_km_fare']*$row['user_journey_distance']),
                        'grand_total'=>$TXN_AMOUNT,
                        'conv_charge'=>$conv_charge,
                        'ride_status'=>0,
                        'payment_status'=>$payment_status,
                        'paymenttype'=>$pay_mode,
                        'entry_date'=>date('Y-m-d H:i:s'),
                        'added_by_web'=>$added_by_web,
                    );
                    
                    $this->db->insert('tbl_booking',$data);
                    
                    
                   if($paymenttype=='online')
                   {
                        $this->db->query("UPDATE tbl_user_trans SET status=1 WHERE order_id='$order_id' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0");
                   }
                   else if($paymenttype=='wallet')
                   {
                       
                       $service_url = WALLETAPIURL; //production
                       
                       $payload=array(
                           'user_phone'=>$phone,
                           'order_id'=>$order_id,
                           'trans_id'=>$tarns_id,
                           'credit'=>0,
                           'debit'=>$TXN_AMOUNT,
                           'added_by_web'=>$added_by_web,
                           'service_type'=>'Cab',
                           'description'=>"Debit Rs.".$TXN_AMOUNT." of book Cab. BOOKING ID-".$booking_id,
                           );
                       
                       
                        $ch = curl_init();
                        $headers  = [
                                    'Content-Type: application/json'
                                ];
                        
                        curl_setopt($ch, CURLOPT_URL,$service_url);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));       
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                        $wallet_summary = curl_exec ($ch);
                       
                   }
                   
                    //send notification to driver
                    $driver_data=$this->db->query("SELECT f_token_app FROM tbl_driver WHERE id='".$row['driver_id']."'")->row_array();
                    
                    if($driver_data['f_token_app'])
    	            {
        	            //send notification
        	            $body="Ride has been booked successfully by user. Booking ID-".$booking_id;
        	            $title="Book Ride";
        	            sendNotificationFlutter($row['f_token_app'],$body,$title);
    	            }
                   
                    $response['booking_id']=$booking_id;
                    $status='success';
                    $message='Your cab has been booked successfully';
                    $statusCode=200;
                }
                else
                {
                    $status='error';
                    $message='Something went wrong. Your request not found';
                    $statusCode=400;
                }
            }
            else
            {
                 $status='error';
                $message='Something went wrong your payment not verified..!';
                $statusCode=400;  
            }
            
        }
        else
        {
            $status='error';
            $message='Please fill in all required fields.';
            $statusCode=400;  
        }
        $response['status']=$status;
		$response['message']=$message;
		$response['statusCode']=$statusCode;
		echo json_encode($response);
    }
    
    
    
    public function conv_charge()
    {
        
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
    $method = $_SERVER['REQUEST_METHOD'];
    
    
    if($method == 'POST'){
        
     $qry = "SELECT * FROM tbl_conv_charge where status = 0 ";
      $result = $this->db->query($qry)->row_array();
      
       $qr = "SELECT * FROM tbl_cod_sts  ";
      $rt = $this->db->query($qr)->row_array();
        if(!empty($result) || !empty($rt)){
           $response['status'] =200;
           $response['conv_charge']=$result['amt'];
        $response['cod_sts']=$rt['status']; 
        $response['message']=  'Success'; 
        
          
    }else{
        
    $response = array('status' => 400,'message' => ' DATA not available  .');  
    
    
    }
    
    	echo json_encode($response);
            
        }
}
    
   
    
    
    
    
    
    public function CancleBookedCab()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $booking_id=$data->booking_id;
    	$reason=$data->reason;
    	$phone=$data->user_phone;
    	if($booking_id && $reason && $phone)
    	{
    	    $qry="SELECT * FROM tbl_booking WHERE book_id='$booking_id'";
            $row=$this->db->query($qry)->row_array();
            
            if(!empty($row))
            {
	            
	            if($row['ride_status']==0)
	            {
            	    $data=array('ride_status'=>3,'is_cancle'=>1,'cancle_reason'=>$reason,'cancle_date'=>date('Y-m-d H:i:s'));
            	    $this->db->where('book_id',$booking_id);
            	    $this->db->update('tbl_booking',$data);
    	            
    	            if($row['payment_status']==1)
    	            {
    	                $service_url = WALLETAPIURL; //production
                           
                           $payload=array(
                               'user_phone'=>$phone,
                               'order_id'=>$row['order_id'],
                               'trans_id'=>$row['trans_id'],
                               'credit'=>$row['grand_total'],
                               'debit'=>0,
                               'added_by_web'=>$row['added_by_web'],
                               'service_type'=>'Cab',
                               'description'=>"Credit Rs.".$row['grand_total']." of cancelled booking by user. BOOKING ID-".$booking_id,
                               );
                           
                           
                            $ch = curl_init();
                            $headers  = [
                                        'Content-Type: application/json'
                                    ];
                            
                            curl_setopt($ch, CURLOPT_URL,$service_url);
                            curl_setopt($ch, CURLOPT_POST, 1);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));       
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            $wallet_summary = curl_exec ($ch);
    	            }
    	            
    	            
    	            $qry="SELECT f_token_app FROM tbl_driver WHERE id='".$row['driver_id']."'";
                    $driver_row=$this->db->query($qry)->row_array();
    	            
    	            if(!empty($driver_row))
    	            {
    	                $body="Your accepted request has been booking successfully BOOKING ID-".$booking_id." Please start ride";
        	            $title="Accepted request has been book by user ";
        	            sendNotificationFlutter($driver_row['f_token_app'],$body,$title);
    	            }
    	            
    	            
    	            $status='success';
                    $message='Cab has been cancelled successfully';
                    $statusCode=200;  
	            }
	            else
	            {
	                if($row['ride_status']==1)
	                {
	                     $status='error';
                        $message='You can not cancel ride becuase it already started';
                        $statusCode=400;  
	                }
	                else
	                {
	                    $status='error';
                        $message='You can not cancel ride.';
                        $statusCode=400;  
	                }
	            }
            }
    	    else
    	    {
    	        $status='success';
                $message='Booking Details not found';
                $statusCode=400;  
    	    }
    	    
    	}
    	else
    	{
    	    $status='error';
            $message='Something went wrong';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    public function trip_history()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $user_id=$data->user_id;
        $pageno= $data->pageno;
        
        if($user_id)
        {
             $limit = 10;  
                if($data->pageno)
                { 
                    $pn  = $data->pageno; 
                } 
                else { 
                    $pn=1; 
                };  
                
            $start_from = ($pn-1) * $limit;
            
             $startdate='';
            $enddate='';
            if($data->daterange)
            {
                $ex=explode(" - ",$data->daterange);
                if(!empty($ex))
                {
                    $fromdate=$ex[0];
                    $todate=$ex[1];
                
                    $date = str_replace('/', '-', $fromdate);
                    $startdate=date('Y-m-d', strtotime($date));
                    
        
                    $date1 = str_replace('/', '-', $todate);
                    $enddate=date('Y-m-d', strtotime($date1));
                }
            }

            $datefilter_qry="";
            if($startdate && $enddate)
            {
                $datefilter_qry=" AND STR_TO_DATE(b.entry_date,'%Y-%m-%d') BETWEEN '$startdate' AND '$enddate'";
            }
            
            $qry="SELECT b.*,DATE_FORMAT(b.entry_date,'%d/%m/%Y %H:%i %p') AS entrydate,vt.name as vehicle_name,vt.image as vehicle_image
            FROM tbl_booking b
            INNER JOIN tbl_vehicletype vt ON vt.id=b.type_id WHERE b.user_id='$user_id' $datefilter_qry";
            
            $limit_qry=" ORDER BY b.id DESC LIMIT $start_from,$limit";
            $result=$this->db->query($qry.$limit_qry)->result_array();
            $total=$this->db->query($qry)->num_rows();
            $number_of_page = ceil ($total / $limit); 
             
            if(!empty($result))
            {
                $i=0;
                foreach($result as $row)
                {
                    $response['list'][$i]['id']=$row['id'];
                    $response['list'][$i]['book_id']=$row['book_id'];
                    $response['list'][$i]['pickup_address']=$row['pickup_address'];
                    $response['list'][$i]['drop_address']=$row['drop_address'];
                    $response['list'][$i]['vehicle']=$row['vehicle_name'];
                    $response['list'][$i]['vehicle_image']=base_url().$row['vehicle_image'];
                    $response['list'][$i]['user_journey_distance']=$row['user_journey_distance'];
                    $response['list'][$i]['total_fare']=$row['total_fare'];
                    $response['list'][$i]['total_wait_charge']=$row['total_wait_charge'];
                    $response['list'][$i]['grand_total']=$row['grand_total'];
                    
                    if($row['ride_status']==0) 
                    {
                        $ride_status="Pending";
                    }
                    else if($row['ride_status']==1) 
                    {
                        $ride_status="Start";
                    }
                    else if($row['ride_status']==2) 
                    {
                        $ride_status="Completed";
                    }
                    else if($row['is_cancle']==1) 
                    {
                        $ride_status="Cancelled";
                    }
                    $response['list'][$i]['ride_status']=$ride_status;
                    $response['list'][$i]['payment_status']=($row['payment_status']==0) ? 'Pending' : 'Paid';
                    $response['list'][$i]['is_cancle']=$row['is_cancle'];
                    $response['list'][$i]['cancle_date']=$row['cancle_date'];
                    $response['list'][$i]['cancle_reason']=$row['cancle_reason'];
                    $response['list'][$i]['entry_date']=$row['entrydate'];
                    $response['list'][$i]['is_arrived_destination']= $row['is_arrived_destination'];
                    $i++;
                }
                
                if($number_of_page > 1)
                {
                    if($number_of_page == $pn)
                    {
                        $response['nextpage']=0;
                    }
                    else
                    {
                        $response['nextpage']=$pn+1;
                    }
                }
                else
                {
                    $response['nextpage']=0;
                }
                
                $message='Data found';
                $status='success';
                $statusCode=200;
            }
            else
            {
                $response['list']=[];
                $message='Data Not found';
                 $status='success';
                 $statusCode=200;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    public function trip_history_details()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $booking_id=$data->booking_id;
        
        
        if($booking_id)
        {
            $qry="SELECT b.*,DATE_FORMAT(b.entry_date,'%d/%m/%Y %H:%i %p') AS entrydate,
            vt.name as vehicle_name,vt.image as vehicle_image ,dr.mobile_no, dr.driver_name ,dr.driver_profile_pic,v.number
            FROM tbl_booking b 
            INNER JOIN tbl_vehicletype vt ON vt.id=b.type_id 
            INNER JOIN tbl_vehicle v ON v.driver_id=b.driver_id
            INNER JOIN  tbl_driver dr ON dr.id = b.driver_id  WHERE b.book_id='$booking_id'";
            
            $row=$this->db->query($qry)->row_array();
           
            if(!empty($row))
            {
                
                $response['id']=$row['id'];
                $response['book_id']=$row['book_id'];
                $response['pickup_address']=$row['pickup_address'];
                $response['pickup_lat']=$row['pickup_lat'];
                $response['pickup_long']=$row['pickup_long'];
                $response['drop_address']=$row['drop_address'];
                $response['drop_lat']=$row['drop_lat'];
                $response['drop_long']=$row['drop_long'];
                $response['vehicle']=$row['vehicle_name'];
                $response['vehicle_image']=base_url().$row['vehicle_image'];
                $response['user_journey_distance']=$row['user_journey_distance'];
                $response['total_fare']=$row['total_fare'];
                $response['total_wait_charge']=$row['total_wait_charge'];
                $response['grand_total']=$row['grand_total'];
                $response['driver_name']=$row['driver_name'];
                $response['driver_img']= base_url().$row['driver_profile_pic'];
                
                
                if($row['ride_status']==0) 
                {
                    $ride_status="Pending";
                }
                else if($row['ride_status']==1) 
                {
                    $ride_status="Start";
                }
                else if($row['ride_status']==2) 
                {
                    $ride_status="Completed";
                }
                else if($row['is_cancle']==1) 
                {
                    $ride_status="Cancelled";
                }
                $response['ride_status']=$ride_status;
                $response['payment_status']=($row['payment_status']==0) ? 'Pending' : 'Paid';
                $response['is_cancle']=$row['is_cancle'];
                $response['paymenttype']=$row['paymenttype'];
                $response['cancle_date']=$row['cancle_date'];
                $response['cancle_reason']=$row['cancle_reason'];
                $response['entry_date']=$row['entrydate'];
                
                $response['deliveryboy_mobileno']=$row['mobile_no'];
                $response['is_arrive']=$row['is_arrive'];
                
                $response['conv_charge']=$row['conv_charge'];
                $response['post_paymenttype']=$row['post_paymenttype'];
                $response['final_grandtotal']=$row['final_grandtotal'];
                
                $response['is_arrived_destination']= $row['is_arrived_destination'];
                $response['vehical_number']= $row['number'];
                $message='Data found';
                $status='success';
                $statusCode=200;
            }
            else
            {
                
                $message='Data Not found';
                 $status='success';
                 $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    
    public function afterpaynow_online()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $booking_id=$data->booking_id;
        $conv_charge=$data->conv_charge;
        
        
    	if($booking_id)
    	{
    	    $qry="SELECT * FROM tbl_booking WHERE book_id='$booking_id'";
            $row=$this->db->query($qry)->row_array();
            
            if(!empty($row))
            {
    	        if($row['payment_status']==0)
    	        {
    	            $total_payble=round(($row['per_km_fare']*$row['user_journey_distance'])+$conv_charge,2); 
    	            $total_payble=round($total_payble+$row['total_wait_charge']);
    	        }
                else
                {
                    $total_payble=round($row['total_wait_charge']);
                    $conv_charge=0; 
                }
                
              
                $trans_id=$this->generateTransID();
                
                
                $login_user=array(
    	            'booking_id'=>$row['book_id'],
                    'user_id'=>$row['user_id'],
                    'order_id'=>$row['order_id'],
                    'trans_id'=>$trans_id,
                    'payment_type'=>'online',
                    'trans_amount'=>$total_payble,
                    'conv_charge'=>$conv_charge,
                    'added_by_web'=>$row['added_by_web'],
                    'ip'=>$_SERVER["REMOTE_ADDR"],
                    'entry_date'=>date('Y-m-d H:i:s'),
                );
                
                $this->db->insert('tbl_user_trans',$login_user);
               
                $response['order_id']=$row['order_id'];
                $response['MID']="";
                $response['WEB_CALLBACK_URL']="";
                
                $response['CONV_CHARGE']=(int)$conv_charge;
                $response['MAIN_AMOUNT']=$total_payble-$conv_charge;
                $response['TXN_AMOUNT']=$total_payble;
                $response['CUST_ID']=$trans_id;
                $response['booking_id']=$row['book_id'];
                $response['payment_type']='online';
    
                $status='success';
                $message='success';
                $statusCode=200;
    	    }
    	    else
    	    {
    	        $status='error';
                $message='This booking not valid for payment';
                $statusCode=400;  
    	    }
    	}
    	else
    	{
    	    $status='error';
            $message='Booking id required';
            $statusCode=400;    
    	}
    	
        $response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
     
    public function after_onlinepayment_verify()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $orderno=$data->orderno;
        $tarns_id=$data->tarns_id;
        $TXN_AMOUNT=$data->TXN_AMOUNT;
        $user_id=$data->user_id;
       

        if(isset($orderno) && isset($tarns_id) && isset($TXN_AMOUNT) && isset($user_id))
        {
            $check_payment=$this->db->query("SELECT * FROM tbl_user_trans WHERE order_id='$orderno' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0")->row_array();

            if(!empty($check_payment))
            {
                $response['payment_verify']=true;
                
                // $this->db->query("UPDATE tbl_user_trans SET status=1 WHERE order_id='$orderno' AND trans_amount='$TXN_AMOUNT' AND trans_id='$tarns_id' AND user_id='$user_id' AND status=0");
                
                // $this->db->query("UPDATE tbl_booking SET payment_status=1 WHERE book_id='".$check_payment['booking_id']."'");
                
                $qry="SELECT * FROM tbl_booking WHERE order_id='$orderno'";
                $row=$this->db->query($qry)->row_array();
                
                if(!empty($row))
                {
        	        $total_payble=round($TXN_AMOUNT+$row['total_wait_charge']);
                    
                    $data_update=array(
                       'final_grandtotal'=>$total_payble,
                       'payment_status'=>1,
                       'post_paymenttype'=>'online',
                       'post_payment_status'=>1,
                      );
                      
                    $this->db->where('book_id',$row['book_id']);  
                    $this->db->update('tbl_booking',$data_update);
                    
                    
                    $qry="SELECT f_token_app FROM tbl_driver WHERE id='".$row['driver_id']."'";
                    $driver_row=$this->db->query($qry)->row_array();
    	            
    	            if(!empty($driver_row))
    	            {
    	                $body="Rs.".$total_payble." Pay using online payment mode by user. Booking ID-".$row['book_id'];
        	            $title="Payment Done";
        	            sendNotificationFlutter($driver_row['f_token_app'],$body,$title);
    	            }
        	            
            
                }
            }
            else
            {
                $response['payment_verify']=false;
            }

            $status='success';
            $message='success';
            $statusCode=200;
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
  
    
    public function afterpaynow_wallet()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $booking_id=$data->booking_id;
        
    	
    	if($booking_id)
    	{
    	    $qry="SELECT b.*,u.mobile_no FROM tbl_booking b
    	    INNER JOIN tbl_user u ON u.id=b.user_id
    	    WHERE b.book_id='$booking_id'";
            $row=$this->db->query($qry)->row_array();
            
            if(!empty($row))
            {
                
                 $total_payble=round(($row['per_km_fare']*$row['user_journey_distance']),2); 
                 
                if($row['payment_status']==0)
    	        {
    	           
    	            $total_payble=round($total_payble+$row['total_wait_charge']);
    	            
    	            $final_grandtotal=$total_payble;
    	            
    	            $description="Debit Rs.".$total_payble." of book Cab. BOOKING ID-".$booking_id;
    	        }
                else
                {
                    $final_grandtotal=round($total_payble+$row['total_wait_charge']);
                    
                    $total_payble=round($row['total_wait_charge']);
                   
                    $description="Debit Rs.".$total_payble." of book Cab waiting charge. BOOKING ID-".$booking_id;
                }
                
    	         
                $data_update=array(
                   'final_grandtotal'=>$final_grandtotal,
                   'payment_status'=>1,
                   'post_paymenttype'=>'Wallet',
                   'post_payment_status'=>1,
                  );
                  
                $this->db->where('book_id',$booking_id);  
                $this->db->update('tbl_booking',$data_update);
                
                
                if($total_payble > 0)
                {
                
                    $service_url = WALLETAPIURL; //production
                           
                    $payload=array(
                       'user_phone'=>$row['mobile_no'],
                       'order_id'=>$row['order_id'],
                       'trans_id'=>'',
                       'credit'=>0,
                       'debit'=>$total_payble,
                       'added_by_web'=>$row['added_by_web'],
                       'service_type'=>'Cab',
                       'description'=>$description,
                       );
                   
                   
                    $ch = curl_init();
                    $headers  = [
                                'Content-Type: application/json'
                            ];
                    
                    curl_setopt($ch, CURLOPT_URL,$service_url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));       
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    $wallet_summary = curl_exec ($ch);
                    
                    
                    $qry="SELECT f_token_app FROM tbl_driver WHERE id='".$row['driver_id']."'";
                    $driver_row=$this->db->query($qry)->row_array();
    	            
    	            if(!empty($driver_row))
    	            {
    	                $body="Rs.".$total_payble." Pay using wallet by user. Booking ID-".$row['book_id'];
        	            $title="Payment Done";
        	            sendNotificationFlutter($driver_row['f_token_app'],$body,$title);
    	            }
                }
                $message='Payment has been successfully deduct from the wallet ';
                $status='success';
                $statusCode=200;
    	    }
    	    else
    	    {
    	        $status='error';
                $message='This booking not valid';
                $statusCode=400;  
    	    }
    	}
    	else
    	{
    	    $status='error';
            $message='Booking id required';
            $statusCode=400;    
    	}
    	
        $response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    
    
}

?>