<?php

use \Firebase\JWT\JWT;
use \Firebase\JWT\Key;

if (!function_exists('generateJWT')) {
    function generateJWT($userId,$type, $expiryMinutes = 60)
	{
		$key = getenv('JWT_SECRET');
		
		// Set expiry time for 7 days in seconds
		$expirySeconds = 7 * 24 * 60 * 60;

		$payload = [
			'iss' => base_url(),
			'aud' => base_url(),
			'iat' => time(),
			'exp' => time() + $expirySeconds,
			'id' => $userId,
			'user_type' => $type,
			'type'=>'access'
		];

		return JWT::encode($payload, $key, 'HS256');
	}

}

if (!function_exists('generateRefreshToken')) {
    function generateRefreshToken($userId, $type, $expiryDays = 30)
	{
		$key = getenv('JWT_SECRET');
		$payload = [
			'iss' => base_url(),
			'aud' => base_url(),
			'iat' => time(),
			'exp' => time() + (86400 * $expiryDays), // 30 days
			'id' => $userId,
			'user_type' => $type,
			'type' => 'refresh'
		];
		return \Firebase\JWT\JWT::encode($payload, $key, 'HS256');
	}


}

if (!function_exists('validateJWT')) {
    function validateJWT($token)
    {
        try {
            $key = getenv('JWT_SECRET');
            return JWT::decode($token, new Key($key, 'HS256'));
        } catch (Exception $e) {
            return false;
        }
    }
}
