<?php

namespace App\Controllers\api\v1;
use App\Controllers\BaseController;
// use App\Models\UserModel;

class AuthController extends BaseController
{
    public function login()
	{
		$data = sanitize(getRequestData());

		// Validation rules
		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		$mobile = $data['mobile'];

		// Check if user exists
		$builder = $this->db->table('users');
		$user = $builder->where('mobile', $mobile)->where('delete_status
		', 'false')->get()->getRowArray();
		$otp = 123456;
		// $otp = sendOTP($mobile);
		if (!$otp) {
			return apiResponse(false, 'OTP sending failed');
		}

		// Store OTP in DB
		$otpData = [
			'mobile'     => $mobile,
			'user_type'     => 'user',
			'otp'        => $otp,
			'created_at' => $this->data['datetime'],
		];
		$this->db->table('user_otps')->insert($otpData);
		if ($user) {
			return apiResponse(true, 'Otp send successfully', ['mobile' => $mobile]);
		} else {
			// Insert new user
			$insertData = [
				'mobile'     => $mobile,
				'created_at' => date('Y-m-d H:i:s')
			];
			$this->db->table('users')->insert($insertData);
			$userId = $this->db->insertID();
			generateUsername($userId);
			return apiResponse(true, 'OTP send successfully', ['mobile' => $mobile]);
		}
	}

	public function verifyOtp()
	{
		$data = sanitize(getRequestData());

		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
			'otp'    => 'required|numeric|min_length[4]|max_length[6]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		// Step 1: Check if user exists
		$user = $this->db->table('users')->select('id,username,name,mobile,profile_image')->where('mobile', $data['mobile'])->where('delete_status', 'false')->get()->getRowArray();
		if (!$user) {
			return apiResponse(false, 'User not found with this mobile number');
		}
		
		// Step 2: Validate OTP (within 5 minutes)
		$expiryTime = date('Y-m-d H:i:s', strtotime('-5 minutes'));

		$otpRecord = $this->db->table('user_otps')
			->where('mobile', $data['mobile'])
			->where('user_type', 'user')
			->where('otp', $data['otp'])
			->where('created_at >=', $expiryTime)
			->where('verified_at', null)
			->get()->getRowArray();

		if ($otpRecord) {
			// Mark OTP as used
			$this->db->table('user_otps')
				->where('id', $otpRecord['id'])
				->update(['verified_at' => $this->data['datetime']]);
			$token = generateJWT($user['id'],'user');
			$refresh_token = generateRefreshToken($user['id'],'user');
			$tokensTable = $this->db->table('user_tokens');

			// Check if token already exists for this user and user_type
			$existing = $tokensTable->where('user_id', $user['id'])->where('user_type', 'user')->get()->getRowArray();

			if ($existing) {
				// Update existing token row
				$tokensTable->where('id', $existing['id'])->update([
						'access_token'  => $token,
						'refresh_token' => $refresh_token,
						'expires_at'    => date('Y-m-d H:i:s', strtotime('+30 days'))
					]);
			} else {
				// Insert new token row
				$tokensTable->insert([
					'user_id'       => $user['id'],
					'user_type'     => 'user',
					'access_token'  => $token,
					'refresh_token' => $refresh_token,
					'expires_at'    => date('Y-m-d H:i:s', strtotime('+30 days'))
				]);
			}

			return apiResponse(true, 'OTP verified successfully', [
				'token' => $token,
				'refresh_token' => $refresh_token,
				'user'=>$user
			]);
		}

		return apiResponse(false, 'Invalid or expired OTP');
	}

	public function resend_otp()
	{
		$data = sanitize(getRequestData());

		// Validation rules
		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		$mobile = $data['mobile'];
		
		// Check if user exists
		$builder = $this->db->table('users');
		$user = $builder->where('mobile', $mobile)->get()->getRowArray();
		if (!$user) {
			return apiResponse(false, 'User not found with this mobile number');
		}
		$otp = 123456;
		// $otp = sendOTP($mobile);
		if (!$otp) {
			return apiResponse(false, 'OTP sending failed');
		}

		// Store OTP in DB
		$otpData = [
			'mobile'     => $mobile,
			'user_type'     => 'user',
			'otp'        => $otp,
			'created_at' => $this->data['datetime'],
		];
		$this->db->table('user_otps')->insert($otpData);
		return apiResponse(true, 'Otp send successfully', ['mobile' => $mobile]);
		
	}
	
	public function refreshToken()
	{
		$data = sanitize(getRequestData());

		if (empty($data['refresh_token'])) {
			return apiResponse(false, 'Refresh token is required.', null, 400);
		}

		$refreshToken = $data['refresh_token'];

		// Lookup token in DB
		$builder = $this->db->table('user_tokens');
		$tokenRecord = $builder->where('refresh_token', $refreshToken)->get()->getRowArray();

		if (!$tokenRecord) {
			return apiResponse(false, 'Invalid refresh token.', null, 401);
		}

		// Optional: check expiry
		if (!empty($tokenRecord['expires_at']) && strtotime($tokenRecord['expires_at']) < time()) {
			return apiResponse(false, 'Refresh token has expired.', null, 401);
		}

		// Generate new access token
		$userId    = $tokenRecord['id'];
		$userType  = $tokenRecord['user_type'];

		$newAccessToken = generateJWT($userId, $userType);
		// Update just access token
		$builder->where('id', $tokenRecord['id'])->update([
			'access_token' => $newAccessToken
		]);

		return apiResponse(true, 'Token refreshed successfully', [
			'token' => $newAccessToken
		]);
	}


    ////   Astrologer ///
	
	 public function login_astro()
	{
		$data = sanitize(getRequestData());

		// Validation rules
		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		$mobile = $data['mobile'];

		// Check if user exists
		$builder = $this->db->table('astrologers');
		$user = $builder->where('mobile', $mobile)->where('delete_status
		', 'false')->get()->getRowArray();
		$otp = 123456;
		// $otp = sendOTP($mobile);
		if (!$otp) {
			return apiResponse(false, 'OTP sending failed');
		}

		// Store OTP in DB
		$otpData = [
			'mobile'     => $mobile,
			'user_type'     => 'astrologer',
			'otp'        => $otp,
			'created_at' => $this->data['datetime'],
		];
		$this->db->table('user_otps')->insert($otpData);
		if ($user) {
			return apiResponse(true, 'Otp send successfully', ['mobile' => $mobile]);
		} else {
			// Insert new user
			$insertData = [
				'mobile'     => $mobile,
				'created_at' => date('Y-m-d H:i:s')
			];
			$this->db->table('astrologers')->insert($insertData);
			$userId = $this->db->insertID();
			generateUsernameAstrologer($userId);
			return apiResponse(true, 'OTP send successfully', ['mobile' => $mobile]);
		}
	}

	public function verifyOtp_astro()
	{
		$data = sanitize(getRequestData());

		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
			'otp'    => 'required|numeric|min_length[4]|max_length[6]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		// Step 1: Check if user exists
		$user = $this->db->table('astrologers')->select('id,username,name,mobile,profile_image')->where('mobile', $data['mobile'])->where('delete_status', 'false')->get()->getRowArray();
		if (!$user) {
			return apiResponse(false, 'User not found with this mobile number');
		}
		
		// Step 2: Validate OTP (within 5 minutes)
		$expiryTime = date('Y-m-d H:i:s', strtotime('-5 minutes'));

		$otpRecord = $this->db->table('user_otps')
			->where('mobile', $data['mobile'])
			->where('user_type', 'astrologer')
			->where('otp', $data['otp'])
			->where('created_at >=', $expiryTime)
			->where('verified_at', null)
			->get()->getRowArray();

		if ($otpRecord) {
			// Mark OTP as used
			$this->db->table('user_otps')
				->where('id', $otpRecord['id'])
				->update(['verified_at' => $this->data['datetime']]);
			$token = generateJWT($user['id'],'astrologer');
			$refresh_token = generateRefreshToken($user['id'],'astrologer');
			$tokensTable = $this->db->table('user_tokens');

			// Check if token already exists for this user and user_type
			$existing = $tokensTable->where('user_id', $user['id'])->where('user_type', 'astrologer')->get()->getRowArray();

			if ($existing) {
				// Update existing token row
				$tokensTable->where('id', $existing['id'])->update([
						'access_token'  => $token,
						'refresh_token' => $refresh_token,
						'expires_at'    => date('Y-m-d H:i:s', strtotime('+30 days'))
					]);
			} else {
				// Insert new token row
				$tokensTable->insert([
					'user_id'       => $user['id'],
					'user_type'     => 'astrologer',
					'access_token'  => $token,
					'refresh_token' => $refresh_token,
					'expires_at'    => date('Y-m-d H:i:s', strtotime('+30 days'))
				]);
			}

			return apiResponse(true, 'OTP verified successfully', [
				'token' => $token,
				'refresh_token' => $refresh_token,
				'user'=>$user
			]);
		}

		return apiResponse(false, 'Invalid or expired OTP');
	}

	public function resend_otp_astro()
	{
		$data = sanitize(getRequestData());

		// Validation rules
		$rules = [
			'mobile' => 'required|numeric|min_length[10]|max_length[10]',
		];

		if (!$this->validateData($data, $rules)) {
			return apiResponse(false, $this->validator->getErrors(), null, 400);
		}

		$mobile = $data['mobile'];
		
		// Check if user exists
		$builder = $this->db->table('astrologers');
		$user = $builder->where('mobile', $mobile)->get()->getRowArray();
		if (!$user) {
			return apiResponse(false, 'User not found with this mobile number');
		}
		$otp = 123456;
		// $otp = sendOTP($mobile);
		if (!$otp) {
			return apiResponse(false, 'OTP sending failed');
		}

		// Store OTP in DB
		$otpData = [
			'mobile'     => $mobile,
			'user_type'     => 'astrologer',
			'otp'        => $otp,
			'created_at' => $this->data['datetime'],
		];
		$this->db->table('user_otps')->insert($otpData);
		return apiResponse(true, 'Otp send successfully', ['mobile' => $mobile]);
		
	}
}
