<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
 $routes->get('test', 'Api::test');
$routes->group('api/v1/user', function($routes) {
    $routes->post('login', 'api\v1\AuthController::login');
    $routes->post('resend-otp', 'api\v1\AuthController::resend_otp');
    $routes->post('verify-otp', 'api\v1\AuthController::verifyOtp');
    $routes->post('refresh-token', 'api\v1\AuthController::refreshToken');
});


$routes->group('api/v1/user', ['filter' => 'jwt:user'], function ($routes) {
    $routes->get('get-profile', 'api\v1\UserController::profile');
    $routes->post('update-fcm-token', 'api\v1\UserController::update_fcm_token');
    $routes->get('get-languages', 'api\v1\UserController::list_languages');
    $routes->get('get-services', 'api\v1\UserController::list_services');
    $routes->post('profile-setup', 'api\v1\UserController::profile_setup');
    $routes->post('update-profile', 'api\v1\UserController::update_profile');
    $routes->post('update-profile-image', 'api\v1\UserController::update_profile_image');
    $routes->post('submit-review', 'api\v1\UserController::submit_review');
    $routes->post('delete-review', 'api\v1\UserController::delete_review');
    $routes->post('list-reviews', 'api\v1\UserController::list_reviews');
    $routes->post('get-all-astrologers', 'api\v1\UserController::get_all_astrologers');
    $routes->post('get-astrologers-by-services', 'api\v1\UserController::get_astrologers_by_service');
    $routes->post('get-popular-astrologers', 'api\v1\UserController::popular_astrologers');
    $routes->post('astrologer-details', 'api\v1\UserController::astrologer_details');
    $routes->post('add-remove-favorite', 'api\v1\UserController::toggle_favorite');
    $routes->get('get-favorite-list', 'api\v1\UserController::favorite_list');
    $routes->post('available-slots', 'api\v1\UserController::available_slots');
    $routes->post('book-service', 'api\v1\UserController::book_service');
    $routes->post('cancel-booking', 'api\v1\UserController::cancel_booking');
    $routes->post('create-walet-order', 'api\v1\UserController::create_wallet_order');
    $routes->post('verify-wallet-payment', 'api\v1\UserController::verify_wallet_payment');
    $routes->post('get-booked-session', 'api\v1\UserController::get_booked_sessions');
    $routes->post('all-booked-session', 'api\v1\UserController::all_booked_sessions');
    $routes->post('booking-history', 'api\v1\UserController::booking_history');
    $routes->post('wallet-history', 'api\v1\UserController::wallet_history');
    $routes->post('logout', 'api\v1\UserController::logout');
    $routes->post('delete-account', 'api\v1\UserController::delete_account');
   
}); 


//// Astrologer ////

$routes->group('api/v1/astrologer', function($routes) {
    $routes->post('login', 'api\v1\AuthController::login_astro');
    $routes->post('resend-otp', 'api\v1\AuthController::resend_otp_astro');
    $routes->post('verify-otp', 'api\v1\AuthController::verifyOtp_astro');
    $routes->post('refresh-token', 'api\v1\AuthController::refreshToken');
});


$routes->group('api/v1/astrologer', ['filter' => 'jwt:astrologer'], function ($routes) {
    $routes->get('get-profile', 'api\v1\AstrologerController::profile');
	$routes->get('get-languages', 'api\v1\AstrologerController::list_languages');
    $routes->get('get-specializations', 'api\v1\AstrologerController::list_specializations');
    $routes->get('get-services', 'api\v1\AstrologerController::list_services');
    $routes->post('update-fcm-token', 'api\v1\AstrologerController::update_fcm_token');
    $routes->post('profile-setup', 'api\v1\AstrologerController::profile_setup');
    $routes->post('save-availability', 'api\v1\AstrologerController::save_availability');
    $routes->get('get-availability', 'api\v1\AstrologerController::get_availability');
    $routes->post('delete-availability', 'api\v1\AstrologerController::delete_availability');
	$routes->post('update-profile', 'api\v1\AstrologerController::update_profile');
    $routes->post('update-profile-image', 'api\v1\AstrologerController::update_profile_image');
    $routes->post('upcoming-bookings', 'api\v1\AstrologerController::upcoming_bookings');
    $routes->post('new-bookings-request', 'api\v1\AstrologerController::new_bookings_request');
    $routes->post('booking-history', 'api\v1\AstrologerController::booking_history');
    $routes->post('update-booking-status', 'api\v1\AstrologerController::booking_status');
    $routes->post('logout', 'api\v1\AstrologerController::logout');
    $routes->post('delete-account', 'api\v1\AstrologerController::delete_account');
});

