<?php

if (!function_exists('sanitize_input')) {
    /**
     * Sanitize array or string input recursively
     *
     * @param mixed $data
     * @return mixed
     */
    function sanitize($data)
    {
        if (is_array($data)) {
            return array_map('sanitize', $data);
        }

        // Individual string sanitization
        $data = trim($data);
        $data = strip_tags($data);         // Remove HTML tags
        $data = htmlspecialchars($data);   // Convert special chars

        return $data;
    }
}
