<?php
// if (!function_exists('getRequestData')) {
    // function getRequestData()
    // {
        // $request = \Config\Services::request();
        // $contentType = $request->getHeaderLine('Content-Type');
        // $isJson = strpos($contentType, 'application/json') !== false;

        // if ($isJson) {
            // try {
                // return $request->getJSON(true);
            // } catch (\Exception $e) {
                // return []; // fallback if JSON is malformed
            // }
        // }

        // return $request->getPost(); // for form-data or x-www-form-urlencoded
    // }
// }

if (!function_exists('getRequestData')) {
    function getRequestData()
    {
        $request = \Config\Services::request();
        $contentType = $request->getHeaderLine('Content-Type');
        $isJson = strpos($contentType, 'application/json') !== false;

        if ($isJson) {
            $rawInput = $request->getBody();
            $data = json_decode($rawInput, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                // Return error response or throw exception
                http_response_code(400);
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => false,
                    'message' => 'Invalid JSON: ' . json_last_error_msg(),
                    'error_code' => 400
                ]);
                exit;
            }

            return $data;
        }

        // For form-data or x-www-form-urlencoded
        return $request->getPost();
    }
}
