<?php 

if (!function_exists('generateUsername')) {
    function generateUsername($user_id)
    {
        $db = \Config\Database::connect(); // Get CI4 DB connection

        $prefix = 'BPIAU';
        $year   = date('Y');
        $code   = str_pad($user_id, 3, '0', STR_PAD_LEFT); // zero-padded to 3 digits

        $username = $prefix . $year . $code;

        // Update the username in users table
        $db->table('users')
           ->where('id', $user_id)
           ->update(['username' => $username]);

        return $username;
    }
}
	if (!function_exists('generateUsernameAstrologer')) {
        function generateUsernameAstrologer($user_id)
        {
            $db = \Config\Database::connect(); // Get CI4 DB connection

            $prefix = 'BPIAA';
            $year   = date('Y');
            $code   = str_pad($user_id, 3, '0', STR_PAD_LEFT); // zero-padded to 3 digits

            $username = $prefix . $year . $code;

            // Update the username in users table
            $db->table('astrologers')
            ->where('id', $user_id)
            ->update(['username' => $username]);

            return $username;
        }
    }

    if (!function_exists('generateBookingId')) {
        function generateBookingId($booking_id)
        {
            $db = \Config\Database::connect();

            $prefix = 'BK'; // Booking prefix
            $year   = date('Y');
            $code   = str_pad($booking_id, 5, '0', STR_PAD_LEFT); // Pad to 5 digits

            $bookingId = $prefix . $year . $code;

            // Update booking_id in bookings table
            $db->table('bookings')
            ->where('id', $booking_id)
            ->update(['booking_id' => $bookingId]); // Assuming `booking_uid` column exists

            return $bookingId;
        }
    }
    if (!function_exists('timeAgo')) {
        function timeAgo($date)
        {
            $timestamp = strtotime($date);
            $diff = time() - $timestamp;

            if ($diff < 60) {
                return 'just now';
            } elseif ($diff < 3600) {
                $minutes = floor($diff / 60);
                return $minutes . ' minute' . ($minutes > 1 ? 's' : '') . ' ago';
            } elseif ($diff < 86400) {
                $hours = floor($diff / 3600);
                return $hours . ' hour' . ($hours > 1 ? 's' : '') . ' ago';
            } elseif ($diff < 604800) { // less than 7 days
                $days = floor($diff / 86400);
                return $days . ' day' . ($days > 1 ? 's' : '') . ' ago';
            } elseif ($diff < 2592000) { // less than 30 days
                $weeks = floor($diff / 604800);
                return $weeks . ' week' . ($weeks > 1 ? 's' : '') . ' ago';
            } elseif ($diff < 31536000) {
                $months = floor($diff / 2592000);
                return $months . ' month' . ($months > 1 ? 's' : '') . ' ago';
            } else {
                $years = floor($diff / 31536000);
                return $years . ' year' . ($years > 1 ? 's' : '') . ' ago';
            }
        }
    }
