<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\CommonModel;
use Psr\Log\LoggerInterface;
use Razorpay\Api\Api;
/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = [];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    // protected $session;

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
		$this->CommonModel = new CommonModel();
		$this->db = \Config\Database::connect();
        $this->razorpay = new Api(env('razorpay_key_id'), env('razorpay_key_secret'));
        // Preload any models, libraries, etc, here.
		date_default_timezone_set('asia/kolkata');
		$this->data=[
			'appName'=>'Astrology App',
			'appLink'=>'',
			'date'=>date('Y-m-d'),
			'time'=>date('H:i:s'),
			'ctime'=>date('h:i A'),
			'timestamp'=>date('Y-m-d h:i:s A'),
			'datetime'=>date('Y-m-d H:i:s'),
			'day'=>date('l')
			];
        // E.g.: $this->session = service('session');
    }
}
